//sdFP-10_mega_2

caseDepth = 125.0;
caseWidth = 65.0;
caseHeightBottomPart = 35.0;
caseWall = 2.0;
caseCutoutWidth = caseWidth - 10.0;
caseCutoutDepth = caseWall + 0.02;
caseCutoutHeight = caseHeightBottomPart;
caseDepthInside = caseDepth - caseWall * 2;
caseWidthInside = caseWidth - caseWall * 2;
caseCutoutWOffset = (caseWidth - caseCutoutWidth) / 2;
caseCutoutHOffset = caseCutoutWOffset;
panelThickness = caseWall - 0.3;

module caseTopPart() {
    ridgeLenght = caseDepth - caseWall * 10;
    cube([caseWidth, caseDepth, caseWall]);
    //
    translate([caseCutoutWOffset, 0, caseWall]) {
        cube([caseCutoutWidth, caseWall, caseWall]);
        translate([0, caseWall * 2, 0]) cube([caseCutoutWidth, caseWall, caseWall]);
        translate([0, caseDepth - caseWall, 0]) cube([caseCutoutWidth, caseWall, caseWall]);
        translate([0, caseDepth - caseWall * 3, 0]) cube([caseCutoutWidth, caseWall, caseWall]);
    }
    // side ridges
    translate([0, caseWall * 5, 0]) {
        //low side
        translate([caseWall, 0, caseWall]) 
            cube([caseWall, ridgeLenght, caseWall * 3]);
        translate([caseWall * 0.8, 0, caseWall * 3]) rotate([0, 45, 0])
            cube([caseWall/2, ridgeLenght, caseWall/2]);
        // high side
        translate([caseWidth - caseWall * 2, 0, caseWall]) 
            cube([caseWall, ridgeLenght, caseWall * 3]);
        translate([caseWidth - caseWall * 1.5, 0, caseWall * 3]) rotate([0, 45, 0])
            cube([caseWall/2, ridgeLenght, caseWall/2]);
        
    }
}



module caseBottomPart() {
    difference() {
        // outside
        cube([caseWidth, caseDepth, caseHeightBottomPart]);
        // inside
        translate([caseWall, caseWall, caseWall])
            cube([caseWidthInside , caseDepthInside, caseHeightBottomPart]);
        // front cutout
        translate([caseCutoutWOffset, -0.01, caseCutoutHOffset])
            cube([caseCutoutWidth, caseWall + 0.02, caseCutoutHeight]);
        // back cutout
        translate([caseCutoutWOffset, caseDepth - caseWall - 0.01, caseCutoutHOffset])
            cube([caseCutoutWidth, caseWall + 0.02, caseCutoutHeight]); 
        // ridges
        translate([caseWall * 1.5, caseDepth / 2, caseHeightBottomPart - caseWall * 2])  
            wallRidge(); 
        translate([caseWidth - caseWall * 1.5, caseDepth / 2, caseHeightBottomPart - caseWall * 2])  
            wallRidge(); 
        
    }
    // front and back ridges
    translate([caseWall, caseWall * 2, caseWall]) caseInsideRidge();
    translate([caseWall, caseDepth - caseWall * 3, caseWall]) caseInsideRidge();
    // arduino tray
    translate([caseWall, caseWall * 2 + 0.6, 0]) color("green") tray();
}

module caseInsideRidge() {
    difference() {
        cube([caseWidthInside, caseWall, caseHeightBottomPart - caseWall]);
        translate([caseCutoutWOffset - caseWall,  - 0.01, caseCutoutHOffset - caseWall]) 
            cube([caseCutoutWidth, caseWall + 0.02, caseHeightBottomPart - caseWall]);
    }
}

module tray() {
    $fn = 16;

    arduinoWidth  = 54.1;
    arduinoLength = 102.8;

    trayDepth = 4.0;
    trayWall  = 1.4;
    pillarHeight = 2.4;
    pillarDiam   = 5.5;
    pillarHole   = 2.8;

    difference() {
        cube([arduinoWidth + 2 * trayWall, arduinoLength + 2 * trayWall, trayDepth + trayWall]);
        translate([trayWall, trayWall, trayWall])
            cube([arduinoWidth, arduinoLength, trayDepth + trayWall]);
    }
    
    module pillar() {
        difference() {
            cylinder(d = pillarDiam, h = pillarHeight);
            translate([0, 0, -0.01]) cylinder(d = pillarHole, h = pillarHeight + 0.02);
        }
    }

    translate([trayWall, trayWall, trayWall]) {
        translate([2.5, 15.0, 0])  pillar();
        translate([51.0, 14.0, 0]) pillar();
        translate([17.6, 66.0, 0]) pillar();
        translate([46.0, 66.0, 0]) pillar();
        translate([2.5, 91.0, 0])  pillar();
        translate([51.0, 96.7, 0]) pillar();

    }
}

module wallRidge () {
    rotate([0, 45, 0]) cube([caseWall, caseDepth - 10.0, caseWall], true);
}

module frontPanel(usbCloneOffset = 0) {
    usbBWidth = 12.5;
    usbBHeight = 10.5 + usbCloneOffset / 2;
    usbBWOffset = 10.4 - usbCloneOffset;
    usbBHOffset = 4.4;
    ppWidth = 9.5;
    ppHeight = 11.0;
    ppWOffset = 42.0 - usbCloneOffset;
    ppHOffset = 4.0;
    sdCWidth = 29.0;
    sdCHeight = 3.5;
    sdCWOffset = 15.5;
    sdCHOffset = 25.4;
    difference() {
        cube([caseWidthInside - 0.4, caseHeightBottomPart - caseWall, panelThickness]);
        // USB B
        translate([usbBWOffset, usbBHOffset, -0.01]) 
            cube([usbBWidth, usbBHeight, panelThickness + 0.02]);
        // power plug
        translate([ppWOffset, ppHOffset, -0.01])
            cube([ppWidth, ppHeight, panelThickness + 0.02]);
        // SD Card
        translate([sdCWOffset, sdCHOffset, -0.01])
            cube([sdCWidth, sdCHeight, panelThickness + 0.02]);
    }
}

module subDEHole() {
    $fn = 32;
    subDEcornerRad = 3.0;
    subDEWidth = 19.5;
    subDEHeight = 11.0;
    subDEWidthReduc = 2.0;
    subDEHoleDist = 25.4;
    subDEHoleXOffset = -3.0;
    translate([-subDEWidth/2, -subDEHeight/2, 0]) {
        // sub-DE shaped hole
        hull() {
            translate([subDEcornerRad, subDEHeight - subDEcornerRad, 0]) 
                cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            translate([subDEWidth - subDEcornerRad, subDEHeight - subDEcornerRad, 0]) 
                cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            translate([subDEWidthReduc, subDEcornerRad, 0]) 
                cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            translate([subDEWidth - subDEWidthReduc, subDEcornerRad, 0]) 
                cylinder(r = subDEcornerRad, h = caseWall + 0.02);
        }
        // side holes
        translate([subDEHoleXOffset, subDEHeight / 2, 0]) 
            cylinder(d = 3.0, h = caseWall + 0.02);
        translate([subDEHoleDist + subDEHoleXOffset, subDEHeight / 2, 0]) 
            cylinder(d = 3.0, h = caseWall + 0.02);
    }
}

module backPanel() {
    difference() {
        cube([caseWidthInside - 0.4, caseHeightBottomPart - caseWall, caseWall - 0.3]);
        translate([caseWidthInside/2, caseHeightBottomPart *2 / 3, -0.01])
            subDEHole();
    }
}

//caseBottomPart();
//caseTopPart();
//frontPanel();
frontPanel(2.0); // for china clone Arduino Mega 2560
//backPanel();
