#include <stdio.h>
#define B_TIMDAT 26
#define B_ADCVRT 38
#define B_POWEROFF 42
#define AD1 0x00
#define AD2 0x01
#define DIP 0x02
#define BAT 0x03
#define PSS 0x04
#define CONTINUE 0
#define RESTART 1

char bcd2dec(bcd)
{
  char dec;
  char lsn;
  char msn;

  lsn = bcd & 0x0F;
  msn = bcd & 0xF0;
  msn = msn / 0x10;
  dec = lsn + 10 * msn;
  return dec;
}

char advint(adv)
{
  char tmpint;
  tmpint = 0;
  if ( adv > 124 )
    tmpint = 1;
  if ( adv == 252 )
    tmpint = 2;
  return tmpint;
}

char advfrac(adv)
{
  char tmpfrac;
  tmpfrac = adv * 100/126;
  while ( tmpfrac >= 100 )
    tmpfrac = tmpfrac - 100;
  return tmpfrac;
}

char battint(tbat)
{
  char tmpint;
  tmpint = tbat / 48;
  return tmpint;
}

char battfrac(tbat)
{
  int batfact;
  char tmpfrac;
  batfact = 47000 / 217;
  if ( tbat <= 116 )
    tmpfrac = (tbat * batfact) / 100;
  if ( tbat > 116 && tbat <= 208 )
    tmpfrac = 59 + ((tbat - 120) * batfact) / 100;
  if ( tbat > 208 )
    tmpfrac = 50 + ((tbat - 208) * batfact) / 100;
  while ( tmpfrac >= 100 )
    tmpfrac = tmpfrac - 100;
  return tmpfrac;
}


main()
{
  char adc;
  char bcr;
  char bat;
  char pss;
  FILE *fp;
  char timdat[12];

  int year;
  char month;
  char mday;
  char hour;
  char minute;
  char second;

  char ad1int, ad1frac;
  char ad2int, ad2frac;
  char batint, batfrac;

  biosh(B_TIMDAT, 0, &timdat[0]); 
  year   = 2000 + bcd2dec(timdat[0]);
  month  = bcd2dec(timdat[1]);
  mday   = bcd2dec(timdat[2]);
  hour   = bcd2dec(timdat[3]);
  minute = bcd2dec(timdat[4]);
  second = bcd2dec(timdat[5]); 

  adc = bios(B_ADCVRT, AD1);
  bcr = bios(B_ADCVRT, AD2); 
  bat = bios(B_ADCVRT, BAT); 
  pss = bios(B_ADCVRT, PSS); 
  ad1int = advint(adc);
  ad1frac = advfrac(adc);
  ad2int = advint(bcr);
  ad2frac = advfrac(bcr);
  batint = battint(bat);
  batfrac = battfrac(bat); 

  printf("    Date     Time      ADC  BCR  BAT ATRG\n"); 
        /*YYYY-MM-DD hh:mm:ss : a.aa b.bb c.cc  d */
  printf("%04d-%02d-%02d %02d:%02d:%02d : ", year, month, mday, hour, minute, second);
  printf("%0d.%02d %0d.%02d %0d.%02d  %d\n", ad1int, ad1frac, ad2int, ad2frac, batint, batfrac, pss); 

/*  fp = fopen("log.txt", "a");
  fprintf(fp, "%04d-%02d-%02d %02d:%02d:%02d : ", year, month, mday, hour, minute, second);
  fprintf(fp, "%0d.%02d %0d.%02d %0d.%02d  %d\n", ad1int, ad1frac, ad2int, ad2frac, batint, batfrac, pss); 
  fclose(fp); */
  
/*  bios(B_POWEROFF, RESTART); */
}
