//mikroKit09tray1

$fn = 32;

boardHeight = 1.6;
solderSpace = 1.8;
cpuBoardWidth = 100.0;
cpuBoardDepth = 91.5;
keyDispBoardWidth = 99.5;
keyDispBoardDepth = 95.0;
trayWall = 1.5;

pillarDiam = 5.0;
pillarHeight = solderSpace;
pillarOffset = trayWall + pillarDiam / 2;

trayHeight = boardHeight + solderSpace + trayWall;
keyDispTrayXOffset = -3.0;
keyDispTrayYOffset = cpuBoardDepth + trayWall * 2;

difference() {
    cube([cpuBoardWidth + 2 * trayWall, cpuBoardDepth + 2 * trayWall, trayHeight]);
    translate([trayWall, trayWall, trayWall]) cube([cpuBoardWidth, cpuBoardDepth, trayHeight]);
}
translate([keyDispTrayXOffset, cpuBoardDepth + 2 * trayWall, 0]) {
    difference() {
        cube([keyDispBoardWidth + 2 * trayWall, keyDispBoardDepth + 2 * trayWall, trayHeight]);
        translate([trayWall, trayWall, trayWall]) cube([keyDispBoardWidth, keyDispBoardDepth, trayHeight]);
    }
}

translate([pillarOffset, 0, trayWall]) {
    translate([0, pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);
    translate([cpuBoardWidth - trayWall - pillarOffset , pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);   
}
translate([pillarOffset, cpuBoardDepth - pillarOffset - trayWall, trayWall]) {
    translate([0, pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);
    translate([cpuBoardWidth - trayWall - pillarOffset , pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);   
}

translate([pillarOffset + keyDispTrayXOffset, keyDispTrayYOffset, trayWall]) {
    translate([0, pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);
    translate([keyDispBoardWidth - trayWall - pillarOffset , pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);   
}
translate([pillarOffset + keyDispTrayXOffset, keyDispTrayYOffset + keyDispBoardDepth - pillarOffset - trayWall, trayWall]) {
    translate([0, pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);
    translate([keyDispBoardWidth - trayWall - pillarOffset , pillarOffset, 0]) cylinder(d = pillarDiam, h = solderSpace);   
}
