//backPlateUSBPlug4
$fn = 32;

wall = 1.0;
plateThick = 2.0;
plateWidth = 72.0;
plateHeight = 18.0;
plateRounding = 1.0;
holeDist = 64.0;

panel();

module panel() {
    difference() {
        dcHolePlate();
        translate([0, 0, -0.01]) {
            usbHole(4.0);
            translate([-holeDist / 2, 0, 0]) cylinder(d = 3.0, h = wall * 3);
            translate([ holeDist / 2, 0, 0]) cylinder(d = 3.0, h = wall * 3);        
        }
    }
    translate([0, 1.5, 10.0]) rotate([90, 0, 0]) #usbPcbCradle();
}

//translate([0, 1.5, 20]) usbBackPlate();
    

module usbBackPlate() {
    width = 20.0;
    height = usbCheight + wall * 2;
    difference() {
        cube([width, height, 1.5], true);
        translate([ 8.0, -1.0, -0.76]) cylinder(d = 2.6, h = 2.0);
        translate([-8.0, -1.0, -0.76]) cylinder(d = 2.6, h = 2.0);
    }
}

module dcHolePlate() {
    translate([0, 0, plateThick]) DCshell(wall);
    taperPlate();
}

module taperPlate() {
    plateWoffset = plateWidth/2 - plateRounding;
    plateHoffset = plateHeight/2 - plateRounding;
    hull() {
        translate([-plateWoffset, 0, 0]) {
            translate([0, -plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
            translate([0,  plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
        }
        translate([ plateWoffset, 0, 0]) {
            translate([0, -plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
            translate([0,  plateHoffset, 0]) cylinder(r1 = 0.1, r2 = plateRounding, h = plateThick);
        }
    }
}

module subDEHoles(wall) {
    $fn = 32;
    // side holes
    translate([-3.0, 11.0 / 2, 0]) 
        cylinder(d = 3.0, h = wall + 0.02);
    translate([63.5 + 3.0, 11.0 / 2, 0]) 
        cylinder(d = 3.0, h = wall + 0.02);
 }

module DCshell(wall) {
    $fn = 32;
    subDEcornerRad = 3.0;
    subDEWidth = 57.4;
    subDEHeight = 11.0;
    subDEWidthReduc = 2.0;
    subDEHoleDist = 63.5;
    subDEHoleXOffset = -3.0;
    caseWall = wall;
    translate([0, 0, 0]) {
    // sub-DE shaped hole
        hull() {
            translate([0, subDEHeight/2 - subDEcornerRad, 0]) {
                translate([-subDEWidth/2 + subDEcornerRad, 0, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([ subDEWidth/2 - subDEcornerRad, 0, 0])
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            }
            translate([0, -subDEHeight/2 + subDEcornerRad, 0]) {
                translate([-subDEWidth/2 + subDEcornerRad, 0, 0])
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
                translate([ subDEWidth/2 - subDEcornerRad, 0, 0]) 
                    cylinder(r = subDEcornerRad, h = caseWall + 0.02);
            }
        }
    }
}

usbCheight = 2.5 + 1.0;
usbCwidth = 8.3 + 0.8;
usbPcbWidth = 12.1;
usbPcbDepth = 14.1;
usbPcbThick = 1.1;

module usbHole(wall = 2.0) {
    usbOffset = (usbCwidth - usbCheight) / 2;
    taper = 4.5;
    hull() {
        translate([-usbOffset, 0, 0]) cylinder(d1 = usbCheight + taper, d2 = usbCheight, h = wall);
        translate([ usbOffset, 0, 0]) cylinder(d1 = usbCheight + taper, d2 = usbCheight, h = wall);
    }
}

module usbPcbCradle() {
    translate([0, 0, 0]) {
        difference() {
            cube([usbPcbWidth + wall * 8, usbPcbDepth, usbCheight + wall * 2], true);
            translate([0, 0, -wall/2]) cube([usbPcbWidth, usbPcbDepth + 3, usbPcbThick], true);
            translate([0, 0, usbPcbThick]) cube([usbCwidth + 1, usbPcbDepth + 3, wall * 4], true);
            rotate([90, 0, -0.01]) {
                translate([ 8.0, 1, -usbPcbDepth/2 - 1]) cylinder(d = 2.3, h = usbPcbDepth + 2);
                translate([-8.0, 1, -usbPcbDepth/2 - 1]) cylinder(d = 2.3, h = usbPcbDepth + 2);
            }
        }
    }
}

//usbPcbCradle();

//translate([0, 0, -1]) color("red") cube([57.4, 2, 2], true);