.TH cw2dmk 1
.SH Name
cw2dmk \- Read a floppy disk using a Catweasel controller
and make an exact copy in DMK format
.SH Syntax
.B cw2dmk [options] filename.dmk
.SH Description
The cw2dmk program uses the Catweasel universal floppy disk controller
to read a disk and save its contents to a file.  The save file is
written in the DMK format first used by some TRS-80 Model I/III/4/4P
emulators.  The disk is exactly reproduced, including the positioning
and spacing of sectors and the content of gaps, so that even so-called
copy protected disks can be read correctly and will work with
emulators.  Currently, cw2dmk can read all formats that can be written by
the Western Digital 177x/179x disk controllers used in the original
TRS-80 machines, all formats that can be written by the NEC
765-compatible floppy disk controllers used in PCs, and the Digital
Equipment Corporation RX02 format.

The cw2dmk program automatically recognizes most variations of drive
type and disk format, but you can override this autodetection with
command line arguments; see below.  Detection of FM (single density)
or MFM (double/high density) encoding works even for disks that have
some sectors in each encoding on the same track, such as disks that
were made to boot on both TRS-80 Models I and III.  

Versions of cw2dmk exist for both Linux and MS-DOS.  On Linux, cw2dmk
must be run as root.  If the program is made setuid to root, it drops
its root privileges as soon as it has obtained access to the block of
I/O ports it needs to directly access the Catweasel.  On Windows 95,
cw2dmk.exe can be run in an MS-DOS Prompt box.  On plain MS-DOS,
cw2dmk.exe needs the program cwsdpmi.exe (included) to provide DPMI
functionality; make sure it is in the same directory as cw2dmk.exe or
in another directory on your path.

cw2dmk accesses the hardware directly, so it must not be used at the
same time as any other Catweasel software.  In particular, on Linux,
do not load Michael Krause's "cwfloppy" driver at the same time, and
on MS-DOS, do not load the "catbase" driver that comes with the
Catweasel.

For more information about the Catweasel controller and other
software that works with it, see:
.nf
    http://www.jschoenfeld.com/
    http://www.soundtracker.org/raw/
.fi

For information about
the DMK file format and the emulators that use it, see:
.nf
    http://discover-net.net/~dmkeil/
    http://www.tim-mann.org/xtrs.html
.fi
.SH Options
.TP
.B \-d \fIdrive\fP
Specify the drive unit number, 0 or 1.  Specify -1 to have
cw2dmk try drive 0 first, then drive 1 if drive 0 does not seem to
exist.  The default setting is -1.
.TP
.B \-v \fIverbosity\fP
Specify how much output is printed.  Larger numbers select more
output.  The default setting is 2.  You can ask for different amounts
of output to be logged to a logfile and to the screen (i.e., stdout)
by giving a two-digit number.  The first digit specifies how much
output to log to the logfile, the second how much to log to the
screen.
.RS
.TP
0
No output.
.TP
1
Print a summary at the end of conversion.
.TP
2
Also print the number of good sectors and errors on each track.
When a retry is needed, print the number of errors on the previous
try and the retry number.
.TP
3
Also print the sector numbers, plus a short message in brackets
when an error is encountered or the FM/MFM encoding detector fires.
.TP
4
Also print the track IDs and DAMs (data address marks).
.TP
5
Also print all data in hexadecimal.  Print "{" and "}" to indicate
where the index hole sensor went on and off.
Print "(-N)" or "(+N)"
where the decoder dropped or duplicated N clock/data bits in an attempt to
resynchronize itself with the data bit and byte boundaries.
Print a "?" before any byte where a
clock was unexpectedly missing or unexpectedly present even after the
resynchronization heuristics were applied.
.TP
6
Like 4, but also print the data as raw characters.
.TP
7
Like 5, but also print the histogram generated when autodetecting the
drive and media type, and print each Catweasel sample and its
classification as short (s), medium (m), or long (l).  Enclose the
decoded hexadecimal data bytes in angle brackets ("< >") to
distinguish them from the samples.
.RE
.TP
.B \-u \fIlogfile\fP
Specify the filename to log output to.  The default is not to log
to a file unless you give a two-digit -v option.  If you give a two-digit
-v option and do not give the -u option, the default logfile name 
is formed by stripping any extension off the DMK file name and 
appending .log instead.  If you give the -u option with a one-digit -v
option, the same output is logged to the file and to the screen.
.P
The remaining options are usually not needed.  cw2dmk will ordinarily
detect or guess the correct values.
.TP
.B \-p \fIport\fP
For the Catweasel MK1 (ISA), port should be the I/O port base, or
0 to default to the factory setting of 0x320.  For the Catweasel MK3 
or MK4 (PCI),
port should be 0 for the first Catweasel card in the machine, 1 for the
second, etc.  The default is 0.
.TP
.B \-k \fIkind\fP
Specify the type of drive and type of media in use.  This option is
generally not needed, as cw2dmk should always autorecognize the correct
value.  You can use it if you want to eliminate the slight delay for
autodetection, or in the special case where you want
to treat a 3.5-inch high density disk as an 8-inch disk (ignoring the last 1/6
of each track) by giving the -k3 option where -k4 would have been the
autorecognized value.  Possible values:
.RS
.TP
1
5.25-inch SD/DD disk in 1.2MB drive
.TP
2
5.25-inch SD/DD disk in 360KB/720KB drive, or 3.5-inch SD/DD disk 
.TP
3
5.25-inch HD disk, or 8-inch SD/DD disk
.TP
4
3.5-inch HD disk
.RE
.TP
.B \-m \fIsteps\fP
Step multiplier, 1 or 2.  A step multiplier of 2 is used when reading
a 40-track (or 35-track) disk in an 80-track drive.  If this option is
not given, cw2dmk guesses a likely value and checks its guess by
trying to read the first few tracks.  If the guess appears to have
been wrong, cw2dmk will use the opposite value instead.  Giving this
option will speed up cw2dmk slightly by eliminating the time to check
the guess, and will remove the small possibility that the guess is
wrong even after having been checked (which can happen only with
copy-protected disks that are formatted with nonstandard track
numbers).  The initial guess is 2 if the drive/media type (-k option) is
set or autodetected to be 1; otherwise the initial guess is 1.
.TP
.B \-t \fItracks\fP
Specifies the number of tracks per side.  If this option is not given,
cw2dmk will guess 43 if the -m option is set (or guessed) to be 2,
otherwise 86.  If cw2dmk is operating with a guessed value for -t, and
the next track after one of the more likely ending places 
(35, 40, 77, or 80 tracks) has no valid sectors or has the same logical
track number as the previous track, it will lower its guess
and immediately stop reading at that point.
.TP
.B \-s \fIsides\fP
Specifies the number of sides.  If this option is not given, cw2dmk
will guess 2 sides if the second side appears to be formatted, then
revise its guess to 1 side if there are no valid sectors on the first
track or two of the second side.  Giving the -s1 option explictly for
a single-sided disk will save the time needed for this autodetection.
.TP
.B \-w \fIfmtimes\fP
Normally, FM bytes are written into the DMK file twice (-w2),
so that they take up the correct proportion of the space on mixed-density
tracks.  You can set -w1 to cause FM bytes to be written only once.
This does not save space in the DMK file unless you also reduce the track
length with the -l option.
.TP
.B \-e \fIencoding\fP
Overrides the normal FM/MFM/RX02 autodetection.  To try only FM
decoding, specify -e1; to try only MFM, specify -e2; to try only RX02,
specify -e3.  Using this option does not speed up cw2dmk appreciably;
however, it can help on noisy disks where the decoder occasionally
makes an error because it has to take all three possible encodings
into account.

Additional notes on DEC RX02 disks: These disks use a nonstandard
encoding for double density.  A slight extension to the DMK format is
used to represent them: Bit 5 (previously unused) is set in the DMK
header's options byte (byte 4).  The DMK double density flag (bit 15
of the IDAM pointer) is not set for RX02 double density sectors, on
the grounds that only the data and CRC are in MFM, not the ID, DAM,
gap, etc.  A program reading a DMK with the RX02 option bit set should
expect a sector to contain twice as many valid data bytes as its
sizecode indicates if the sector's DAM is 0xf9 (deleted RX02 MFM data)
or 0xfd (normal RX02 MFM data).  Note that as with other disk types,
FM bytes are written to the DMK file twice unless you set the -w1
option, while MFM bytes are written only once.  RX02 autodetection
will fail if the first track with RX02 sectors has only deleted data
(0xf9 DAMs).  This is unlikely to occur, but using -e3 will work
around the problem if it does.
.P
The following are special options for dealing with hard to read disks.
.TP
.B \-x \fIretries\fP
While reading a track, cw2dmk tries to recognize sector IDs and sector
data, and it checks that each ID has a corresponding sector and that
both have correct CRCs.  If any of these checks fail, cw2dmk will try
reading the track again, up to the number of additional times
specified by this option.  The default value is 4.  If you have an old
disk with CRC errors, increasing the number of retries to a large
value may still allow the disk to be read.  If you have a
copy-protected disk with intentional CRC errors, or other strange
formatting that cw2dmk interprets as a possible error, you might want
to reduce or eliminate the retries to speed up the conversion.
.TP
.B \-a \fIalternate\fP
This option is used only when when reading a 40-track disk in an
80-track drive (-m2).  If -a is set to 0 (the default) cw2dmk reads
from the even-numbered head positions, skipping the odd-numbered ones.
That is, disk track n is read from head position 2n.
Occasionally, more data may be recoverable by reading at the next higher
head position.  If you set -a to 1, cw2dmk will always read at odd
positions (2n+1).  If -a is 2 or 3, cw2dmk will alternate
between even and odd positions when retries are needed to read a track,
trying even positions first if -a is 2; odd if -a is 3.
.TP
.B \-o \fIpostcomp\fP
If you have a disk that shows a lot of CRC errors, you can try
re-reading it with different values for this parameter.  The default
is currently 0.5.  Try larger values if errors occur mostly on
high-numbered tracks, smaller values if errors occur on lower-numbered
tracks or all tracks.  Values must be between 0.0 and 1.0.

Exactly what does this option do?  The magnetic flux transitions on a
floppy disk tend to move slightly farther apart if they are recorded
very close together, thus lengthening the short intervals and
shortening the long ones, a phenomenon sometimes called
bit-shifting.  When a disk is recorded, the disk controller
ordinarily applies write-precompensation to reduce this effect;
that is, it makes the short intervals extra short and the long ones
correspondingly longer, especially on the inner, higher-numbered
tracks.  Sometimes a disk is recorded with too little write
precompensation, or perhaps the bits shift even more as the disk ages.
With the postcomp option enabled, if cw2dmk observes that an interval
is longer or shorter than its nominal length, it will assume that the
interval's ending transition moved slightly, and will lengthen or
shorten the next interval as a sort of read-postcompensation.  The
deviation of each interval is multipled by the value of the postcomp
option before being added to the next interval.
.TP
.B \-h \fIhole\fP
If hole is 1 (the default), cw2dmk uses the disk's index hole to
determine where each track starts.  If hole is set to 0, cw2dmk reads
disks without using the index hole.  With -h0, the tracks in the DMK
file will not start with the same sector as on the original disk (but
the -i option can sometimes fix this; see below).  Note that if the
disk actually has no index hole, cw2dmk cannot autodetect the
drive/media type, so you must also give the -k option to specify the
type.

One case where the -h0 option is useful is if the last sector on a
track wraps around far past the index hole and is partially cut off by
cw2dmk's normal reading method.

The -h0 option can also be useful with one type of "flippy" disk.
Generally, a flippy disk is a disk that has a separate single sided
format written on each side, where the format on the back was written
by flipping the disk over and inserting it into the drive upside-down.
You can't read the back of a flippy disk using the side 1 head of a
double-sided drive; cw2dmk could compensate for the disk rotating the
wrong way, but a more serious problem is that the side 1 head on a
double-sided drive is offset inward a few tracks from the side 0
head, so it cannot reach the first few tracks on the back of a
flippy.  This is not a problem if your disk was written on flippy
media, which has an index hole on each side of the jacket and a write
protect notch on each edge; such media can be flipped over and read in
any drive.  But some flippy disks consist of non-flippy media that was
written in a flippy drive; that is, the disk has only one index hole
and write protect notch in the jacket, but the drive that was used to
write it had two index hole sensors and two write protect sensors, one
for each side.  If you have the latter kind of flippy disk but no
flippy drive, the disk can be difficult to read.  You could punch an
extra hole in the disk's jacket, thus converting it to flippy media,
or you can read the disk with cw2dmk using the -h0 option.  However,
there is a catch with trying to use the -h0 option: although cw2dmk
itself does not need to see an index hole in that case, most modern
floppy drives will not let you read any data from a disk unless the
drive itself has seen some index holes going by since you inserted it.
Older drives may work, or you may be able to rejumper or modify a
newer drive.  On a Mitsubishi MF504B or MF504C drive, remove the RD
jumper.  For drives that don't have such a jumper, see
.nh
http://siliconsonic.de/t/flipside.html
.hy 1
for a modification idea.
.TP 
.B \-g \fIigno\fP
Causes cw2dmk to ignore the first igno bytes 
decoded on each track.  If igno is negative, an extra -igno bytes
of padding are inserted at the beginning of each track.
.TP
.B \-i \fIipos\fP
If this option is given, cw2dmk forces the first IAM (index address
mark) encountered to be exactly ipos bytes from the physical start of
the track, by ignoring bytes or adding padding at the start of the
track as with the -g option.  The default value is -1, which disables
this feature.

This feature can be useful in conjuction with the -h0 option.  If your
disk was originally formatted with an IAM at the start of each track,
cw2dmk can start the tracks at the same point in the DMK file, even
though the -h0 option keeps it from being able to use the physical
index hole to find the start.  For this purpose, -i96 is a good value
to make sure that gap0 (the pre-IAM gap) is large enough to meet the
IBM format spec.  Use a smaller value if -i96 causes the last sector
of some tracks to be partially cut off.

This feature can also be useful to reproduce certain copy-protected
disks exactly.  Some copy-protection schemes work only if the data is
precisely positioned on the physical track. If you have this problem,
you may need to experiment with different values for the -i or -g options.
.TP
.B \-z \fImaxsize\fP
Change the maximum value expected for IBM-compatible sector size
codes.  This option does not affect the actual data that is read from
the disk and written to the DMK file; it affects only the CRC checking
and error retry algorithm described under the -x option above.  The
default value is correct for disks that were written by Western
Digital WD177x/179x controllers used in TRS-80s.  On most of these
controllers, only the two low-order bits of the code are ever
significant, and the sector size is given by 128 << (code & 3).  On
the 1771, there is also an optional "non-IBM" feature that can be
selected when a sector is read or written.  When this feature is used,
the sector size is given by 16 * code (or 16 * 256 if code is zero).
As a heuristic, cw2dmk assumes the non-IBM feature was used if a
sector is recorded in FM (single density) and its size code is more
than maxsize.  In contrast, with NEC765-compatible floppy disk
controllers as used in PCs, the sector size is given by 128 << (code &
7).  Thus if you have a disk written by a PC with sectors larger than
1024 bytes, setting maxsize to 7 will allow cw2dmk to correctly
determine the sector sizes and avoid reporting false CRC errors.
.TP
.B \-r \fIreverse\fP
If reverse is 1, cw2dmk reverses the sides of the disk; that is, it
reads side 0 of the DMK file from physical side 1 of the disk and side
1 of the DMK (if any) from physical side 0 of the disk.  The default
is 0, which does not reverse the sides.  This option is most likely to
be useful if you have a disk that was recorded in a double-sided drive
with a separate single-sided filesystem on each side.  Reading such a
disk twice, once with -s1 -r0 and once with -s1 -r1, gives you a
separate 1-sided DMK image of each side of the disk.  (Note: this
option is not useful for reading the back of a flippy disk; see the
-h0 option.)
.P
The next few options modify individual
parameters that are normally set correctly by the -k option (or by
autodetection of the correct value for the -k option).  These options can
be given only after the -k option.  To see the default values
for a particular disk kind N, type the command
"cw2dmk -kN" with no other arguments; they will be shown
in brackets in the usage message.
.TP
.B \-c \fIclock\fP
Catweasel sample rate multiplier.  1 selects 7.080 MHz, 2 selects
14.161 MHz, and (on Catweasel MK3 and MK4 only) 4 selects 28.322 MHz.
.TP
.B \-1 \fIthreshold\fP
MFM threshold for short (10) vs. medium (100), in number of samples.
.TP
.B \-2 \fIthreshold\fP
MFM threshold for medium (100) vs. long (1000), in number of samples.
.TP
.B \-f \fIthreshold\fP
FM threshold for short (1) vs. long (10), in number of samples.
Used only in -e1 mode; in the default mode where encoding is
autodetected on the fly, FM samples must lie outside the range between
the two MFM thresholds to be decoded correctly.
.TP
.B \-l \fIbytes\fP
DMK track length in bytes.  The maximum is 0x4000 hex or 16384
decimal.  Note that cw2dmk uses this value as part of its heuristic to
determine when it has read one complete track and is starting to see
wraparound back to the start of the track.  If the DMK track buffer
is more than 95% full and a sector with the same header as the first
sector on the track is seen again, cw2dmk assumes it has wrapped
around to the start of the track again and stops reading.  This
heuristic will be defeated if you set the track length to a huge
value, so set it at most a few percent higher than the default for the
disk kind (-k option) you are using.
.SH Limitations
Here are some cases where the results may not be correct
unless an additional command line option is given.

If the disk has a defect but can be successfully read
by using a larger number of retries than normal, use the -x option.

If the disk is noisy, cw2dmk's decoder may sometimes misclassify a
sample or even misdetect the encoding (FM, MFM, or RX02), usually
resulting in a CRC error or a missing sector.  You can sometimes work
around this (especially for FM-only disks) by using the -e option to
force only one encoding to be considered.  Another workaround that can
help is the -o option.  In rare cases, tweaking thresholds with the
-1, -2, and -f options may help.  The histogram displayed by the -v7
option or the separate testhist program may help you find the best
thresholds.

If the disk was formatted with more than 43 tracks in a 40-track
drive, or more than 86 tracks in an 80-track drive, use the -t
option.

Double-stepping is used to read 35- or 40-track disks in an 80-track
drive.  If a copy-protected disk has nonstandard track numbers that
fool cw2dmk when it tries to detect whether the drive needs to be
single or double-stepped, use the -s option.

If the
TRS-80 program on a copy-protected disk does a Read Track when it is
run, and it expects the raw track data to be precisely aligned, but
the data comes out shifted a few bytes forward or backward when read
with the Catweasel, use the -g or -i option.

If the last sector on a track wraps around through the index hole and
extends too far past it, cw2dmk's normal -h1 reading strategy may cut
off the end of it, resulting in a CRC error.  Using the -h0 option may
take care of the problem.

If the disk was made by a NEC765-compatible controller and has
sectors longer than 1024 bytes, use the -z7 option.

If a disk has fewer tracks than cw2dmk guesses, reading will sometimes
continue past the last valid track.  It is harmless for extra tracks
of garbage to be written to the end of the DMK file, but if you know
the correct number of tracks, you can use the -t option to force
cw2dmk to stop at the right place.  Remember that track numbers start
from zero, so (for example) giving the option -t35 will cause tracks
numbered 0 to 34 to be read.

Atari 800 floppy disk drives typically rotate at 288 RPM instead of
300 RPM, allowing for somewhat more data per track than standard
drives, and they write data to the disk without regard for the
position of the index hole.  To read one of these disks with cw2dmk in
a standard floppy drive, give the -h0 option to ignore the index hole
position, the -k1 or -k2 option as needed to specify the kind of drive
and media in use, and the -l 0x1A40 option to increase the DMK track
length.  
.SH Diagnostics
.TP 
.B cw2dmk: Must be setuid to root or be run as root
.PD 0
.TP 
.B cw2dmk: No access to I/O ports
.PD
On Linux, cw2dmk must be made setuid to root or be run as root, or it
will not be able to access the Catweasel's I/O ports and this error
message will appear.
.TP
.B cw2dmk: Failed to detect Catweasel
A Catweasel card was not detected at the specified I/O ports.
.TP
.B cw2dmk: Failed to detect any drives
You did not specify a drive to use with the -d opion, and no drives
were detected.  The track 0 sensor is used to detect the presence of a
drive, so you may get this message if your drive has a broken track 0
sensor.  In that case, use the -d option to select which drive to use.
.TP
.B cw2dmk: Drive d not detected; proceeding anyway
You specified a drive for cw2dmk to use with the -d option, but it was
not detected.  The track 0 sensor is used to detect the presence of a
drive, so you may get this message for a drive with a broken track 0.
However, it's more likely that the specified drive number does not
exist.  Cabling and drive selection can be confusing, so before giving
up, try the other drive number or leave out the -d option and let
cw2dmk autodetect the drive number.  Note: In versions prior to 3.0,
cw2dmk used the opposite drive numbering convention from the bundled
Catweasel software supplied by Individual Computers.  This has now
been corrected.
.TP
.B cw2dmk: Track 0 side 0 is unformatted
For drive/media autodetection to work, track 0 of the diskette must
be formatted.  This message is printed if the track appears not to be
formatted.
.TP
.B cw2dmk: Failed to detect drive and media type
This message is printed if drive/media autodetection fails for some
unknown reason.  The detector's estimate of the data clock rate and
disk rotation speed are also printed; if they are wildly wrong, the
disk may be unformatted.
.TP
.B cw2dmk: Read error
.PD 0
.TP
.B cw2dmk: No index hole detected
.TP
.B cw2dmk: No index hole; can't detect drive and media type
.TP
.B cw2dmk: No index hole; can't detect if side 1 is formatted
.PD
Either the drive reported that it was not ready when the Catweasel tried to 
read from it, or no index hole was detected.
These messages usually mean that there is no disk in the
drive.  They might also appear in some cases if the drive is not connected
properly, the door is not closed, the disk is inserted upside-down, etc.

If the disk really does not have an index hole -- in particular, if
you are reading the back of a disk that was written in a flippy drive
by inserting it upside-down into a normal drive (see the -h0 option) --
cw2dmk cannot autodetect the drive and media type or if side 1 is
formatted, so you will have to give the -k and -s flags to tell it the
correct type and number of sides.
.TP
.B Possibly a flippy disk; check reverse side too
This message is not an error.  It means that you are reading a disk in
a double-sided drive and cw2dmk detected there might be "flippy" data
on the back of the disk in addition to the normal data on the front.
cw2dmk cannot read all of this data unless you flip the disk over (see
the -h0 option for details), but it can usually read enough to detect
that there is some data present and print this message.
.TP
.B cw2dmk: Catweasel memory error?! See cw2dmk.txt
If you receive this message on an unformatted track, please ignore it;
nothing is wrong.  

If you receive the message on a formatted track, and you have a
Catweasel MK1 card that was manufactured before July 2000, contact
Individual Computers for information on obtaining an updated version
of the MACH chip in your Catweasel.  If you never see this message,
the update is not needed.

Alternatively, you may be able to work around the problem by using the
Catweasel's lower clock rate (-c1) with appropriately reduced values
for the threshold parameters (-1 and -2 or -f).  The thresholds for
-c1 should be about half the default values used with -c2.  To see the
default threshold values for disk kind number N, type the command
"cw2dmk -kN" with no other arguments; they will be shown in brackets
in the usage message.
.SH Authors
cw2dmk was written by Timothy Mann, http://tim-mann.org/.  It
uses low-level Catweasel access routines written by Michael Krause.
cw2dmk is free software, released under the GNU General Public License.
Thanks to Jens Schoenfeld for providing documentation on programming
the Catweasel hardware.  Thanks to David Keil for designing and
documenting the DMK file format for floppy disk images.

The DPMI host cwsdpmi.exe is free software, written and copyrighted by
Charles W. Sandmann and released under the GNU General Public license.
You can download the source code and/or binary updates for this
program from ftp://ftp.simtel.net/pub/simtelnet/gnu/djgpp/v2misc/.
Look for files with names of the form csdpmi*.zip.  Note: the highest
version that has been tested with cw2dmk at this writing is 5.

$Id: cw2dmk.man,v 1.31 2010/01/15 23:11:54 mann Exp $
