/* 
 * File:   cw2dmk.h
 * Author: fjkraan
 *
 * Created on December 28, 2012, 9:57 PM
 */

#ifndef CW2DMK_H
#define	CW2DMK_H

#ifdef	__cplusplus
extern "C" {
#endif
    
    /* Note: if track guess is too low, we won't notice, so we go very
   high.  I actually have seen a 43-track disk made in a 40-track
   drive.  However, many drives can't step that far. */
#define TRACKS_GUESS 86

/* Suppress FM address mark detection for a few bit times after each
   data CRC is seen.  Helps prevent seening bogus marks in write
   splices. */
#define WRITE_SPLICE 32
    
#define CWMAXTRACKSIZE  128 * 1024

    /* Note: out_level values are used in usage message and on command line */
#define OUT_QUIET 0
#define OUT_SUMMARY 1
#define OUT_TSUMMARY 2
#define OUT_ERRORS 3
#define OUT_IDS 4
#define OUT_HEX 5
#define OUT_RAW 6
#define OUT_SAMPLES 7


typedef struct {
    int port;
    int tracks;
    int sides;
    int steps;
    int drive;
    int retries;
    int alternate;
    int fmtimes; /* record FM bytes twice; see man page */
//    int total_retries;
    int kind;
    int reverse;
    FILE *dmk_file;
    char *dmkFileName;
    FILE *dump_file;
    char *dumpFileName;
} UserParams_t;

typedef struct {
    int total_errcount;
    int total_good_sectors;
    int good_tracks;
    int err_tracks;
    int total_retries;
} ReportingValues_t;

#define CWIMAGESIGNATURE 3
typedef struct {
    signed char signature[CWIMAGESIGNATURE];
    signed char clock;
} CWImageHeader_t;

typedef struct {
    unsigned char trackMSB;
    unsigned char trackLSB;
    unsigned char headMSB;
    unsigned char headLSB;
    unsigned char sectorMSB;
    unsigned char sectorLSB;
    unsigned char trackSizeMMSB;
    unsigned char trackSizeMSB;
    unsigned char trackSizeLSB;
    unsigned char trackSizeLLSB;
} CWImageTrackHeader_t;


void initializeDecoderParams(DecoderParams_t *decoderParams);
void initializeUserParams(UserParams_t *userParams);
void initializeDmkParams(DmkParams_t *dmkParams, dmk_header_t * dmk_header);
void initializeReportingValues(ReportingValues_t *reportingValues);
void initializeCWTrackHeader(CWImageTrackHeader_t *cwImageTrackHeader, int track, int head, int sector, int ttrackSize);

#ifdef	__cplusplus
}
#endif

#endif	/* CW2DMK_H */

