#!/bin/sh

NCD_NAME=ncdu82

TXT_TO_PS=/usr/local/bin/lwf
PS_TO_PS=cat
NCD_LW_DRIVER=/u/mrj/spool/psncd
TMP=/tmp

width=""
length=""
indent=""
name=unknown
host=unknown
acct_file=""
date=`date`

while [ $# -gt 0 ]
do
    case "$1" in
	-c)
	    echo bad flag to filter: $1 >&2
	    exit 1
	    ;;
	-w*)
	    width="$1"
	    ;;
	-l*)
	    length="$1"
	    ;;
	-i*)
	    indent="$1"
	    ;;
	-n)
	    if [ $# -gt 1 ]
	    then
		shift
		name="$1"
	    fi
	    ;;
	-h)
	    if [ $# -gt 1 ]
	    then
		shift
		host="$1"
	    fi
	    ;;
	-*)
	    echo bad flag to filter: $1 >&2
	    exit 1
	    ;;
	*)
	    acct_file="$1"
	    ;;
    esac
    shift
done

trap "rm -f $TMP/$$" 0

cat << EOF > $TMP/$$
%!PS-Adobe-2.0
%%Creator: $name
%%CreationDate: $date
%%For: $name
%%DocumentFonts: Courier Times-Roman
%%Pages: 1
%%EndComments
/B {NW 0 rmoveto}bind def
/EP {SV restore /#copies exch def showpage}bind def
/L /lineto load def
/M /moveto load def
/NP /newpath load def
/S /show load def
/SHP {SP 2 setlinewidth}bind def
/SLP {SP 612 0 translate 90 rotate}bind def
/SP {/SV save def findfont exch scalefont setfont ( )
  stringwidth pop dup /W exch def neg /NW exch def}bind def
/ST /stroke load def
/T {W mul 0 rmoveto}bind def
%%EndProlog
%%Page: 1
18 /Times-Roman SHP
NP 25 700 M
425 700 L
25 694 M
425 694 L
ST
25 670 M
(User: $name)S
25 646 M
(Host: $host)S
25 622 M
(Date: $date)S
25 598 M
(File: <stdin>)S
NP 25 586 M
425 586 L
25 580 M
425 580 L
ST
1 EP
%%Trailer
%%Pages: 1
EOF

#/u/mrj/spool/if \
#    -p "($PS_TO_PS $TMP/$$ -) | $NCD_LW_DRIVER $NCD_NAME" \
#    -t "($PS_TO_PS $TMP/$$; $TXT_TO_PS) | $NCD_LW_DRIVER $NCD_NAME" \
#    $width $length $indent -n "$name" -h "$host" $acct_file

/u/mrj/spool/if \
    -p "($PS_TO_PS - $TMP/$$) | $NCD_LW_DRIVER $NCD_NAME" \
    -t "($TXT_TO_PS; $PS_TO_PS $TMP/$$) | $NCD_LW_DRIVER $NCD_NAME" \
    $width $length $indent -n "$name" -h "$host" $acct_file
