/***********************************************************
Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: dwf_util.c,v 1.7 88/10/10 19:34:56 rws Exp $ */

#include <stdio.h>
#include <X11/Xos.h>
#include <sys/stat.h>

#include <X11/X.h>
#include <X11/Xproto.h>
#include <X11/Xmd.h>

#include "fontstruct.h"
#include "snfstruct.h"
#include "bdftosnf.h"

#include "fontdir.h"

/* from dwf.h..... */
#define DWF_MAGIC 0x1df5e76
typedef struct {
    CARD32	magic;		/* offs: 0x00 */
    INT16	headerLength;	/* usually == sizeof(dwfInfo) */
    INT16	nameLength;	/* length of font name */
    INT16	propLength;	/* length of properties area */
    INT16	propStringsLength;	/* length of properties strings */
} dwfPrefix;

int
getshort(p)
    unsigned short * p;
{
    unsigned char * P = (unsigned char * )p;
    int v,w;
    v = *P++;
    w = *P++;
    return((w<<8)+v);
}

int
getlong(p)
    int * p;
{
    unsigned char * P = (unsigned char * )p;
    return(getshort(P) + (getshort(P+2)<<16));
}

void GetDWFFontName( fp, font_name)
    FILE *fp;
    char *font_name;
{
    int		bytestoread;
    int		i;
    struct stat	stats;
    int		c;
    dwfPrefix	prefix;
    int		magic;
    int		nameLength;
	
    bytestoread = sizeof(dwfPrefix);
    if ( fread((char *)&prefix, 1, bytestoread, fp) != bytestoread) {
	font_name[0] = NUL;
        return;
    }

    magic = getlong(&prefix.magic);
    if (magic != DWF_MAGIC) {
	font_name[0] = NUL;
	return;
    }

    if ((i = getshort(&prefix.headerLength)) != 0x54) {
	font_name[0] = NUL;
	return;
    }

    /* skip what we find unintersting */
    fstat(fileno(fp), &stats);
    if ((stats.st_mode & S_IFMT) == S_IFREG)
	fseek(fp, i, 1);
    else
	while (i-- && ((c = getc(fp)) != EOF))
	    ;
    
    nameLength = getshort(&prefix.nameLength);
    if ( fread(font_name, 1,	nameLength, fp) != nameLength) {
	font_name[0] = NUL;
        return;
    }
}
