/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: os.h,v 1.34 89/03/22 18:15:21 rws Exp $ */

#ifndef OS_H
#define OS_H
#include "misc.h"

#ifdef INCLUDE_ALLOCA_H
#include <alloca.h>
#endif

#define NullFID ((FID) 0)

#define SCREEN_SAVER_ON   0
#define SCREEN_SAVER_OFF  1
#define SCREEN_SAVER_FORCER 2

#define MAX_REQUEST_SIZE 16384

typedef pointer	FID;
typedef struct _FontPathRec *FontPathPtr;
typedef struct _NewClientRec *NewClientPtr;

#ifndef NO_ALLOCA
/*
 * os-dependent definition of local allocation and deallocation
 * If you want something other than Xalloc/Xfree for ALLOCATE/DEALLOCATE
 * LOCAL then you add that in here.
 */
#if defined(__HIGHC__)

extern char *alloca();

#if HCVERSION < 21003
#define ALLOCATE_LOCAL(size)	alloca((int)(size))
pragma on(alloca);
#else /* HCVERSION >= 21003 */
#define	ALLOCATE_LOCAL(size)	_Alloca((int)(size))
#endif /* HCVERSION < 21003 */

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* defined(__HIGHC__) */


#ifndef NCD
#ifdef __GNUC__
#define alloca __builtin_alloca
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
#if defined(vax) || defined(sun)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix 
 * ../os/4.2bsd/Imakefile
 */
char *alloca();
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* vax or sun */
#endif /* __GNUC__ */
#else NCD
extern pointer ustackbegin, ustackend;
#define ALLOCATE_LOCAL_MAX 300
#define ALLOCATE_LOCAL(size) ((int)(size)<ALLOCATE_LOCAL_MAX ? \
	__builtin_alloca((int)(size)) : Xalloc((int)(size)))
#define DEALLOCATE_LOCAL(ptr) if((pointer)(ptr) < ustackbegin \
	|| (pointer)(ptr) >= ustackend ) Xfree(ptr)
#endif NCD

#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) Xalloc((unsigned long)(size))
#define DEALLOCATE_LOCAL(ptr) Xfree((pointer)(ptr))
#endif /* ALLOCATE_LOCAL */


#define xalloc(size) Xalloc((unsigned long)(size))
#define xrealloc(ptr, size) Xrealloc((pointer)(ptr), (unsigned long)(size))
#define xfree(ptr) Xfree((pointer)(ptr))


/*
 * The declaration for ReadRequestFromClient should be a xReq *, but
 * then other files must also include Xproto.h and (boo hoo) that
 * would introduce many, many more symbols which would break the less
 * intelligent strain of compilers available today.
 */
char		*ReadRequestFromClient();
char		*strcat();
char		*strncat();
char		*strcpy();
char		*strncpy();
Bool		CloseDownConnection();
FontPathPtr	GetFontPath();
FontPathPtr	ExpandFontNamePattern();
FID		FiOpenForRead();
void		CreateWellKnownSockets();
int		SetDefaultFontPath();
void		FreeFontRecord();
int		SetFontPath();
void		ErrorF();
void		Error();
void		FatalError();
void		ProcessCommandLine();
void		FlushAllOutput();
void		FlushIfCriticalOutputPending();
#ifndef MEMBUG
void		Xfree();
unsigned long	*Xalloc();
unsigned long	*Xrealloc();
unsigned long	*XallocFailOK();
unsigned long	*XreallocFailOK();
#else MEMBUG
void		_Xfree();
unsigned long	*_Xalloc();
unsigned long	*_Xrealloc();
#define Xfree(p) _Xfree(p,__FILE__,__LINE__)
#define Xalloc(s) _Xalloc(s,__FILE__,__LINE__)
#define Xrealloc(p,s) _Xrealloc(p,s,__FILE__,__LINE__)
#define XallocFailOK(s) _XallocFailOK(s,__FILE__,__LINE__)
#define XreallocFailOK(p,s) _XreallocFailOK(p,s,__FILE__,__LINE__)
#endif MEMBUG
long		GetTimeInMillis();

#endif /* OS_H */
