/* ldcf - linux mini dcf deamon
   Reads the pulses from the serial port proper.
   The pulses are 100 ms and 200 ms. At 50 Baud,
   this results in a 0xf0 (100ms) and a 0x0 (200ms) character.

   The time between two characters is measured, and if this
   is about two seconds a new minute just started.
   The pulses are converted to a standard unix tm struct and
   from there to human readable form.
	  
   Bugs: tm.tm_yday is not supported. tm.tm_sec is always zero.
         dates beyond 2079 are not supported. Nor those before 1980, 
	     but that only concerns time travellers.
   */

#include <termios.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
 
#define STDIN 0
 
int main(argc, argv) int argc; char *argv[]; {
    int fd;
    char ch;
    struct termios save;
    struct termios t;
    fd_set rfds;
    struct timeval tv;
    int retval;
    struct tm tim;
    int secno = 0;
    int debug = 1;
    int alt_antenna = 0;
    int zonechange_expect = 0;
    int wintertime = 0;
    int summertime = 0;
    int startcode = 0;
    int leapexpect = 0;
    int parity_min = 0;
    int parity_hour = 0;
    int parity_date = 0;
    static char *day[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
 
    if (argc != 1) {
        fd = open("/dev/ttyS7", O_RDONLY || O_NDELAY);
    } else {
        fd = STDIN; 
    }
 
    tcgetattr(fd, &save);
    t = save;
 
    cfsetispeed(&t, B50);   /* baudrate = 50 baud */
    t.c_lflag &= ECHO;   /* no-echo */
    t.c_lflag &= ~ICANON;   /* non-canonical */
    t.c_lflag &= ~ISIG;     /* no signal character processing */
    t.c_cc[VMIN] = 1;       /* one character at a time */
    t.c_cc[VTIME] = 0;      /* no time-outs */

    tcsetattr(fd, TCSANOW, &t);
    if (debug) {
	printf ("          1    1    2    2    3    3    4    4    5    5    6\n");
        printf ("0    5    0    5    0    5    0    5    0    5    0    5    0\n");
    }

    while (1) {
        /* Watch fd for input */
        FD_ZERO(&rfds);
        FD_SET(fd, &rfds);
        /* Wait up to one.five seconds. */
        tv.tv_sec = 1;
        tv.tv_usec = 500000;

	if (secno == 0) {
            tim.tm_sec = 0;         /* seconds after the minute - [0, 61] */
                                    /* for leap seconds */
            tim.tm_min = 0;         /* minutes after the hour - [0, 59] */
            tim.tm_hour = 0;        /* hour since midnight - [0, 23] */
            tim.tm_mday = 0;        /* day of the month - [1, 31] */
            tim.tm_mon = 0;         /* months since January - [0, 11] */
            tim.tm_year = 2000;     /* see case 57 below! */
            tim.tm_wday = 0;        /* days since Sunday - [0, 6] */
            tim.tm_yday = 0;        /* days since January 1 - [0, 365] */
            tim.tm_isdst = 0;       /* flag for alternate daylight savings time */
            alt_antenna = 0;
            zonechange_expect = 0;
            summertime = 0;
            wintertime = 0;
	    leapexpect = 0;
	    startcode = 0;
	    parity_min = 0;
	    parity_hour = 0;
	    parity_date = 0;
	}
 
        /* select returns the number of ended fd's (always 1 in this case) */
	/* or 0 in case of a timeout. */
	retval = select(1, &rfds, NULL, NULL, &tv);
	if (retval) {
	    ch = readbit(fd);
	    if (ch != -1) {
		if (debug) {
	            printf ("%c", (int)ch);
                    fflush(stdout);
		}
		if (ch == 49) {
                    switch (secno) {
	                case 0: case 1: case 2: case 3: case 4: 
	                case 5: case 6: case 7: case 8: case 9:
	                case 10: case 11: case 12: case 13: case 14: { break; }
	                case 15: { alt_antenna = 1; break; }
			case 16: { zonechange_expect = 1; break; }
			case 17: { summertime = 1; break; }
			case 18: { wintertime = 1; break; }
	                case 19: { leapexpect = 1; break; }
                        case 20: { startcode = 1; break; }

	                case 21: { tim.tm_min += 1; parity_min++; break; }
	                case 22: { tim.tm_min += 2; parity_min++; break; }
	                case 23: { tim.tm_min += 4; parity_min++; break; }
	                case 24: { tim.tm_min += 8; parity_min++; break; }
	                case 25: { tim.tm_min += 10; parity_min++; break; }
	                case 26: { tim.tm_min += 20; parity_min++; break; }
	                case 27: { tim.tm_min += 40; parity_min++; break; }
	                case 28: { parity_min++; break; } /* minute parity */
			
	                case 29: { tim.tm_hour += 1; parity_hour++; break; }
	                case 30: { tim.tm_hour += 2; parity_hour++; break; }
	                case 31: { tim.tm_hour += 4; parity_hour++; break; }
	                case 32: { tim.tm_hour += 8; parity_hour++; break; }
	                case 33: { tim.tm_hour += 10; parity_hour++; break; }
	                case 34: { tim.tm_hour += 20; parity_hour++; break; }
	                case 35: { parity_hour++; break; } /* hour parity */

                        case 36: { tim.tm_mday += 1; parity_date++; break; }
                        case 37: { tim.tm_mday += 2; parity_date++; break; }
                        case 38: { tim.tm_mday += 4; parity_date++; break; }
                        case 39: { tim.tm_mday += 8; parity_date++; break; }
                        case 40: { tim.tm_mday += 10; parity_date++; break; }
                        case 41: { tim.tm_mday += 20; parity_date++; break; }

                        case 42: { tim.tm_wday += 1; parity_date++; break; }
                        case 43: { tim.tm_wday += 2; parity_date++; break; }
                        case 44: { tim.tm_wday += 4; parity_date++; break; }

                        case 45: { tim.tm_mon += 1; parity_date++; break; }
                        case 46: { tim.tm_mon += 2; parity_date++; break; }
                        case 47: { tim.tm_mon += 4; parity_date++; break; }
                        case 48: { tim.tm_mon += 8; parity_date++; break; }
                        case 49: { tim.tm_mon += 10; parity_date++; break; }

                        case 50: { tim.tm_year += 1; parity_date++; break; }
                        case 51: { tim.tm_year += 2; parity_date++; break; }
                        case 52: { tim.tm_year += 4; parity_date++; break; }
                        case 53: { tim.tm_year += 8; parity_date++; break; }
                        case 54: { tim.tm_year += 10; parity_date++; break; }
                        case 55: { tim.tm_year += 20; parity_date++; break; }
                        case 56: { tim.tm_year += 40; parity_date++; break; }
                        case 57: { tim.tm_year += 80; parity_date++;  
			           /* fix this before 2090! */
			           if (tim.tm_year >= 2090) {
			              tim.tm_year -= 100; 
				   }
				   break; }
                        case 58: { parity_date++; break; } /* date parity */

		    }
		    fflush(stdout);
	        }
                secno++;
		/* correction of day count difference: dcf day 7 is sunday */
		if (tim.tm_wday > 6) {
		    tim.tm_wday = 0;
	        }
	    } else {
		printf ("\n### received illegal char! exiting...\n");
                tcsetattr(fd, TCSANOW, &save);
                if (fd == STDIN) {
                    close(fd);
		}
		exit (1);
	    }
	} else {
	    if (secno >= 58) {
	        if  (secno == 60) {
	            if (leapexpect) {
		        printf("\n### Warning! leap second occurred ###");
		    } else {
		        printf("\n### unexpected leap second occurred! ###\n");
		    }
		}
		if (startcode = 0) { printf("\nstartbit not set!"); }
		if (parity_min % 2) { printf("\nminute parity error!"); }
		if (parity_hour % 2) { printf("\nhour parity error!"); }
		if (parity_date % 2) { printf("\ndate parity error!"); }
		if (wintertime == summertime) {printf("\n### Warning! error in time zone setting ###\n"); }
	        printf("\ntime is: %s %04d-%02d-%02d %02d:%02d:00", 
		    day[tim.tm_wday],
		    (int)tim.tm_year, (int)tim.tm_mon, (int)tim.tm_mday, 
		    (int)tim.tm_hour, (int)tim.tm_min);
		if (wintertime) {printf("; MET"); }   
 		if (summertime) {printf("; MET DST"); }   
		if (alt_antenna) {printf("; alt. antenna"); }   
		if (zonechange_expect) {printf("; expecting zone change"); }
		if (leapexpect) {printf("; expecting leap second"); }
		printf("\n");
	        secno = 0;
		leapexpect = 0;
	    } else {
                if (secno != 0) {
	            printf("\n### timeout! restarting ###\n");
	            secno = 0;
                }
	    }
        }
    }
}

int readbit (fd) {
    char ch;  
    if (read(fd, &ch, 1) == 1) {
/*	printf(" ch = %d\n", (int)ch); */
        if (ch == 3) {
            /* This only works if input is the keyboard. */
            printf("\nYou presses ^C, exiting\n");
            if (fd == STDIN) {
                 close(fd);
	    }
            return -1;
        }
	if (ch == 0 || ch == 49) { return 49; }
	if (ch == -32 || ch == 48) { return 48; }
	printf("%d", ch);
	return -1;
    } else {
	printf("\n### Error receiving char. ###\n");
        return -1;
    }
}

int usage() {
    printf("Usage: ldcf [-v] [-d device\n]");
    return 1;
}
